#!/usr/bin/env python
# -*- coding: utf-8 -*- 

from gimpfu import *
import os, sys


#https://discuss.pixls.us/t/characters-of-the-interface-too-small/11189/11?u=mrq
  
def plugin_main(image, drawable, font, font_size, menu):
	fontm = str(font)
	sizem = str(int(font_size))
	menum = str(int(menu))
	
	backup_filefullpath = gimp.directory +  os.sep + 'gtkrc'
	f = open(backup_filefullpath,"wb")
	f.write('gtk-theme-name = "Default"')
	f.write('\nstyle "user-font"')
	f.write('\n{')
	f.write('\n	font_name="' + fontm + ' ' + sizem + '"')
	f.write('\n}')
	f.write('\nwidget_class "*" style "user-font"')
	f.write('\ngtk-icon-sizes = "gtk-menu=' + menum + ',' + menum + '"')	
	f.close()

register(
        "python_fu_font_and_icon_size",
        "This plugin does not resize the icons in Toolbox.\nYou will do it in: Preferences → Interface → Icon Theme. \n\nAfter selecting the value and clicking 'OK' in: \nPreferences→Interface→Theme→Reload Current Theme (click)\nor Restart Gimp.\n\nThis plugin creates a 'gtkrc' file (in your home directory) that is parent of any selected theme. ",
        "Change menu letters and others icons Ver.0.1",
        "MrQ",
        "GPL",
        "2021",
        "<Image>/Windows/Change menu letters & other icons",
        "", 
        [
			#(PF_IMAGE,    "image", "Input image", None), #current image  
			#(PF_DRAWABLE, "layer", "Input layer", None), #current layer
			(PF_FONT,     "font", "Font Menu: ", "Sans"),
			(PF_SPINNER,  "font_size", "Font Size:", 10, (6, 18, 1)),
			(PF_SPINNER,  "menu", "Others Icons Size:", 22, (10, 30, 1)),
		],
        [],
        plugin_main,
        )

main()
